<?php
class ControllerExtensionPaymentTessPayments extends Controller {

	public $currencies_3dotexponent = ['BHD', 'JOD', 'KWD', 'OMR', 'TND'];
    public $currencies_noexponent = [
        //'CLP', 
        'VND', 
        'ISK', 
        'UGX', 
        //'KRW', 
        //'JPY'
    ];
	public function index() {

		$this->load->language('extension/payment/tesspayments');


		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

// Ensure the order is saved in the system before redirecting to payment
$this->load->model('checkout/order');
if (isset($this->session->data['order_id']) && $this->session->data['order_id']) {
    // Use the default order status (Pending)
    $pending_status = $this->config->get('payment_tesspayments_pending_status_id') ?: $this->config->get('config_order_status_id');
    $this->model_checkout_order->addOrderHistory($this->session->data['order_id'], $pending_status, 'TESS Payments initiated.');
}
			$total = $this->currency->format($order_info['total'] - $this->cart->getSubTotal(), $order_info['currency_code'], false, false);



			########################################TESS Payments########################################

			$order_id = $this->session->data['order_id'];
			$first_name = html_entity_decode($order_info['payment_firstname'], ENT_QUOTES, 'UTF-8');
			$last_name = html_entity_decode($order_info['payment_lastname'], ENT_QUOTES, 'UTF-8');
			$country = $order_info['payment_iso_code_2'];
			$city = html_entity_decode($order_info['payment_city'], ENT_QUOTES, 'UTF-8');
			$address = html_entity_decode($order_info['payment_address_1'], ENT_QUOTES, 'UTF-8');
			$zip = html_entity_decode($order_info['payment_postcode'], ENT_QUOTES, 'UTF-8');
			$description = 'Payment Order # ' . $order_id .' in the store ';
			$currency = $order_info['currency_code'];
			$total = $order_info['total'];

            if (in_array($currency, $this->currencies_noexponent)) {
                $amount = number_format($total, 0, '.', '');
            }elseif (in_array($currency, $this->currencies_3dotexponent)) {
                $amount = number_format($total, 3, '.', '');
            }else{
				$amount = number_format($total, 2, '.', '');
			}
			
			$customer = array(
				'name' => $first_name . ' ' . $last_name,
				'email' => $order_info['email'],
			);

			$billing_address = array(
				'country' => $country ? $country : 'NA',
				'city' => $city ? $city : 'NA',
				'address' => $address ? $address : 'NA',
				'zip' => $zip ? $zip : 'NA',
				// 'phone' => $order->get_billing_phone() ? $order->get_billing_phone() : 'NA',
			);

			$order_json = array(
				'number' => "$order_id",
				'description' => $description,
				'amount' => $amount, //may troubles
				'currency' => $currency,
			);
			
			$methods = $this->config->get('payment_tesspayments_method');

			$request_data = [
				'merchant_key' => $this->config->get('payment_tesspayments_merchant_key'),
				'operation'    => 'purchase', //m subs purchase
				'methods'      => $methods,
				'order'        => $order_json,
				'customer'     => $customer,
				'billing_address' => $billing_address,
				'success_url' => HTTPS_SERVER.'/index.php?route=checkout/success',
				'cancel_url'   => HTTPS_SERVER, //
				'hash'         => $this->get_hash('F_hosted', $order_id, $amount, $currency, $customer['email'], $description),
			];

			$fields  = json_encode($request_data);

			$getter = curl_init('https://checkout.tesspayments.com/api/v1/session'); //init curl
            curl_setopt($getter, CURLOPT_POST, 1); //post
            curl_setopt($getter, CURLOPT_POSTFIELDS, $fields); //json
            curl_setopt($getter, CURLOPT_HTTPHEADER, array('Content-Type:application/json')); //header
            curl_setopt($getter, CURLOPT_RETURNTRANSFER, true);

            $res = curl_exec($getter);
            $err = curl_error($getter);
            $httpcode = curl_getinfo($getter, CURLINFO_HTTP_CODE);

			$json = json_decode((string) $res);

			

			if(isset($json->redirect_url) && $json->redirect_url){
				$redirect_url = $json->redirect_url;
				$data['redirect_url'] = $redirect_url;
				$data['result'] = 'success';
			}else{

				foreach($json->errors as $error){
					$data['errors'][] = array(
						'error_code'     => $error->error_code,
						'error_message'    => $error->error_message,
					);
				}
				
				$data['result'] = 'failed';
				$data['error_message'] = $json->error_message;
			}
			
			$data['httpcode'] = $httpcode;
			$data['json'] = json_decode($res);
			
			$callback_url = $this->url->link('extension/payment/tesspayments/callback', '', true);
			
			$data['notification_url'] = $callback_url; 

			return $this->load->view('extension/payment/tesspayments', $data);
	}

	function get_hash($formula, $order_id, $amount, $currency, $payer_email, $description){

		$merchant_password = $this->config->get('payment_tesspayments_merchant_password');
		
		$str_to_hash = $order_id . $amount . $currency . $description . $merchant_password;
		$hash = sha1(md5(strtoupper($str_to_hash)));    
		
		return $hash;
	}

	public function refund() {

		// Check if this is an admin or secure endpoint (optional)
		if (!$this->user || !$this->user->hasPermission('modify', 'extension/payment/tesspayments')) {
			$this->response->setOutput(json_encode(['error' => 'Permission denied']));
			return;
		}

		// Get POST data
		$order_id   = $this->request->post['order_id'] ?? 0;
		$amount     = $this->request->post['amount'] ?? 0;

		// Get payment_id from DB (saved during callback)
		$query = $this->db->query("SELECT tesspayments_payment_id FROM `" . DB_PREFIX . "order` WHERE order_id = '" . (int)$order_id . "'");
		if (!$query->num_rows || empty($query->row['tesspayments_payment_id'])) {
			$this->response->setOutput(json_encode(['error' => 'Payment ID not found for order']));
			return;
		}

		$payment_id = $query->row['tesspayments_payment_id'];

		// Prepare API data
		$merchant_key = $this->config->get('payment_tesspayments_merchant_key');
		$merchant_pass = $this->config->get('payment_tesspayments_merchant_password');

		$to_md5 = strtoupper($payment_id . $amount . $merchant_pass);
		$hash = sha1(md5($to_md5));

		$payload = json_encode([
			'merchant_key' => $merchant_key,
			'payment_id'   => $payment_id,
			'amount'       => $amount,
			'hash'         => $hash
		]);

		// Call refund API
		$ch = curl_init('https://checkout.tesspayments.com/api/v1/payment/refund');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
		$response = curl_exec($ch);
		$error    = curl_error($ch);
		curl_close($ch);

		// Log for debugging
		$this->log->write('TESS Refund Request: ' . $payload);
		$this->log->write('TESS Refund Response: ' . $response);

		// Parse response
		if ($error) {
			$this->response->setOutput(json_encode(['error' => $error]));
			return;
		}

		$result = json_decode($response, true);

		if (isset($result['result']) && strtolower($result['result']) == 'accepted') {
			// Optionally record refund in DB or order history
			$this->model_checkout_order->addOrderHistory($order_id, $this->config->get('payment_tesspayments_refunded_status_id'), 'Refund accepted: ' . $result['payment_id']);
			$this->response->setOutput(json_encode(['success' => true, 'payment_id' => $result['payment_id']]));
		} else {
			$this->response->setOutput(json_encode(['error' => 'Refund not accepted', 'response' => $result]));
		}
	}

	

	public function callback() {
	    
	    file_put_contents('./log_callback.log', json_encode($_POST), FILE_APPEND);

		if (isset($this->request->post['order_number'])) {
			$order_id = $this->request->post['order_number'];
		} else {
			$order_id = 0;
		}

		$this->load->model('checkout/order');

		$order_info = $this->model_checkout_order->getOrder($order_id);

		if ($order_info) {

				$order_status_id = $this->config->get('config_order_status_id');

				switch($this->request->post['status']) {
					case 'Canceled_Reversal':
						$order_status_id = $this->config->get('payment_tesspayments_canceled_reversal_status_id');
						break;
					case 'success':
						$total_paid_match = ((float)$this->request->post['order_amount'] == $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false));

						if ($total_paid_match) {
							$order_status_id = $this->config->get('payment_tesspayments_processed_status_id');
						}
						
						if (!$total_paid_match) {
							$this->log->write('tesspayments :: TOTAL PAID MISMATCH! ' . $this->request->post['order_amount']);
						}
						break;
					case 'Denied':
						$order_status_id = $this->config->get('payment_tesspayments_denied_status_id');
						break;
					case 'Expired':
						$order_status_id = $this->config->get('payment_tesspayments_expired_status_id');
						break;
					case 'failed':
						$order_status_id = $this->config->get('payment_tesspayments_failed_status_id');
						break;
					case 'Pending':
						$order_status_id = $this->config->get('payment_tesspayments_pending_status_id');
						break;
					case 'Processed':
						$order_status_id = $this->config->get('payment_tesspayments_processed_status_id');
						break;
					case 'Refunded':
						$order_status_id = $this->config->get('payment_tesspayments_refunded_status_id');
						break;
					case 'Reversed':
						$order_status_id = $this->config->get('payment_tesspayments_reversed_status_id');
						break;
					case 'Voided':
						$order_status_id = $this->config->get('payment_tesspayments_voided_status_id');
						break;
				}

				//$this->model_checkout_order->addOrderHistory($order_id, $order_status_id);
				$this->db->query("UPDATE `" . DB_PREFIX . "order` 
    SET payment_custom_field = JSON_SET(COALESCE(payment_custom_field, '{}'), '$.tesspayments_payment_id', '" . $this->db->escape($this->request->post['id']) . "')
    WHERE order_id = '" . (int)$order_id . "'");

				$this->model_checkout_order->addOrderHistory($order_id, $order_status_id, 'TESS Payments status: ' . $this->request->post['status'], true);

		}
	}
}