<?php


class  WC_Web_Payment_Gateway_Rest_Webhook
{
    private $gateway;

    public function __construct()
    {
        add_action('rest_api_init', [$this, 'initRoute']);
        add_action('init', [$this, 'setupGateway']);
    }

    public function initRoute()
    {
        register_rest_route(
            'wpgfull/v1',
            '/callback',
            [
                'methods'  => WP_REST_Server::CREATABLE,
                'callback' => [$this->gateway, 'check_ipn_response'],
                'permission_callback' => '__return_true',
            ]
        );

         register_rest_route(
            'wpgfull/v1',
            '/setpicture',
            [
                'methods'  => WP_REST_Server::READABLE,
                'callback' => [$this->gateway, 'get_new_image'],
                'permission_callback' => '__return_true',
            ]
        );
    }

    public function setupGateway()
    {
        $gateways = WC()->payment_gateways()->get_available_payment_gateways();

        if (isset($gateways['wpgfull'])) {
            $this->gateway = $gateways['wpgfull'];
        }
    }
}

new WC_Web_Payment_Gateway_Rest_Webhook();
