<?php
class Wpg_WpgOnPage_Model_Config
{

    public function getAllowedMethods()
    {
        /*
card
afsbenefit
airtel
applepay
awcc
axxi-cash
axxi-transfer
citizen
coinspaid
cybersource
e-xezine
fxmb-india
fxmb-netbanking
help2pay
ipasspay
mpsa
netbanking-upi
paypal
paytota
ppro-alipay
ppro-bitpay
ppro-dragonpay
ppro-fpx
ppro-ideal
ppro-klarna
ppro-przelewy24
ppro-safetypay
ppro-skrill
ppro-sofort
ppro-trustly
ppro-unionpay
ppro-wechat5
ppro-wechatonline
pr-cash
pr-creditcard
pr-cryptocurrency
pr-online
securepaycard
stcpay
unipay
vcard
vp-wallet
zeropay
*/

        $this->writeCallbackUrl();

        $methods = [
            [
                'value' => 'card',
                'label' => 'Card',
                'selected' => true,
            ],
            [
                'value' => 'googlepay',
                'label' => 'GooglePay',
            ],
            [
                'value' => 'applepay',
                'label' => 'ApplePay',
            ],
            [
                'value' => 'playpal',
                'label' => 'PayPal',
            ],
            [
                'value' => 'unipay',
                'label' => 'UniPay',
            ],
            [
                'value' => 'zeropay',
                'label' => 'ZeroPay',
            ],
            [
                'value' => 'citizen',
                'label' => 'Citizen',
            ],
        ];

        return $methods;

        
    }

    public function getNewPaymentStatus()
    {
        $st = new Mage_Adminhtml_Model_System_Config_Source_Order_Status();
        $statuses = $st->toOptionArray();
        $right = [];
        foreach ($statuses as $status) {
            if (!in_array($status['value'], [Mage_Sales_Model_Order::STATE_COMPLETE, Mage_Sales_Model_Order::STATE_CANCELED]) ) {
                $right[$status['value']] = $status['label'];
            }
        }

        return $right;
    }

    public function getAfterPaymentStatus()
    {
        $st = new Mage_Adminhtml_Model_System_Config_Source_Order_Status();
        $statuses = $st->toOptionArray();
        $right = [];
        foreach ($statuses as $status) {
            if (!in_array($status['value'], [Mage_Sales_Model_Order::STATE_COMPLETE, Mage_Sales_Model_Order::STATE_CANCELED]) ) {
                $right[$status['value']] = $status['label'];
            }
        }

        return $right;
    }

    public function writeCallbackUrl(){
        $callback = Mage::getUrl('WpgOnPage/response', array('_secure' => true));
        Mage::getConfig()->saveConfig('payment/WpgOnPage/back_ref' , $callback);
    }

}

