<?php

class Wpg_WpgOnPage_Model_Gateway
{
    public $currencies_3dotexponent = ['BHD', 'JOD', 'KWD', 'OMR', 'TND'];
    public $currencies_noexponent = [
        //'CLP', 
        'VND',
        'ISK',
        'UGX',
        //'KRW', 
        //'JPY'
    ];

    public function getRedirectUrl(Mage_Sales_Model_Order $order)
    {

        if (is_null($order->getIncrementId())) {
            return false;
        }

        //methods
        $methods = $this->getConfigData('cctypes');

        if ($methods == null) {
            $methods = array();
        } else {
            $methods = explode(',', $methods);
        }

        $debug = false;
        if ($debug == true) {
            $methods = array('card');
        }

        //build json
        $address = $order->getBillingAddress();

        $state = $address->getRegionCode();

        $billing_address = [
            'country' => $address->getCountry(),
            'state' => isset($state) ? $state : 'None',
            'city' => $address->getCity(),
            'address' => $address->getStreetFull(),
            'zip' => $address->getPostcode(),
            'phone' => $address->getTelephone(),
        ];

        $customer_data = [
            'name' => $order->getCustomerName(),
            'email' => $order->getCustomerEmail(),
        ];

        //amount 
        $amount = number_format($order->getGrandTotal(), 2, '.', '');
        if (in_array($order->getOrderCurrencyCode(), $this->currencies_noexponent)) {
            $amount = number_format($order->getGrandTotal(), 0, '.', '');
        } elseif (in_array($order->getOrderCurrencyCode(), $this->currencies_3dotexponent)) {
            $amount = number_format($order->getGrandTotal(), 3, '.', '');
        }

        $order_json = array(
            'number' => $order->getIncrementId(),
            'description' => 'Pay order: #' . $order->getIncrementId(),
            'amount' => $amount,
            'currency' => $order->getOrderCurrencyCode(),
        );

        $str_to_hash = $order_json['number'] . $amount . $order_json['currency'] . $order_json['description'] . $this->getConfigData('secretkey');
        $hash = sha1(md5(strtoupper($str_to_hash)));


        $postData = array(
            'merchant_key' => $this->getConfigData('merchantkey'),
            'operation'    => 'purchase',
            'methods'      => $methods,
            'order'        => $order_json,
            'customer'     => $customer_data,
            'billing_address' => $billing_address,
            'success_url' => Mage::getUrl('checkout/onepage/success', array('_secure' => true)),
            'cancel_url'   => Mage::getUrl('/', array('_secure' => true)),
            'hash'         => $hash
        );

        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, rtrim($this->getConfigData('checkouthost'), '/') . '/api/v1/session');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-type: application/json', 'Accept: application/json'));
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));

            $result = curl_exec($ch);
            Mage::log('Request: ' . json_encode($postData), null, 'wpg.log', true);
            Mage::log('Response: ' . $result, null, 'wpg.log', true);

            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            if ($httpcode != 200) {
                return false;
            }
            $response = json_decode($result, true);


            return $response['redirect_url'];
        } catch (Exception $e) {
            return false;
        }

        return false;
    }

    public function refund($order, $amount)
    {
        foreach ($order->getInvoiceCollection() as $invoice) {
            $tr_id = $invoice->getTransactionId();
            if (preg_match('/^[0-9a-fA-F]{8}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{12}$/', $tr_id)) {
                break;
            }
        }

        $amount_format = number_format($amount, 2, '.', '');
        if (in_array($order->getOrderCurrencyCode(), $this->currencies_noexponent)) {
            $amount_format = number_format($amount, 0, '.', '');
        } elseif (in_array($order->getOrderCurrencyCode(), $this->currencies_3dotexponent)) {
            $amount_format = number_format($amount, 3, '.', '');
        }

        $hash = sha1(md5(strtoupper($tr_id . $amount_format . $this->getConfigData('secretkey'))));

        $postData = array(
            'merchant_key' => $this->getConfigData('merchantkey'),
            'payment_id'   => $tr_id,
            'amount'       => $amount_format,
            'hash'         => $hash
        );

        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, rtrim($this->getConfigData('checkouthost'), '/') . '/api/v1/payment/refund');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-type: application/json', 'Accept: application/json'));
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));

            $result = curl_exec($ch);

            Mage::log('RefundRequest: ' . json_encode($postData), null, 'wpg.log', false);
            Mage::log('RefundResponse: ' . $result, null, 'wpg.log', true);

            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);


            if ($httpcode != 200) {
                return false;
            }
            $responseArr = json_decode($result, true);

            if (isset($responseArr['result'])) {
                if ($responseArr['result'] == 'accepted') {
                    return true;
                }
            } else {
                foreach ($responseArr['errors'] as $mes) {
                    return false;
                }
            }
        } catch (Exception $e) {
            return false;
        }

        return false;
    }

    public function getConfigData($key)
    {
        /** @var Wpg_WpgOnPage_Model_WpgOnPage */
        $payment = Mage::getModel('WpgOnPage/WpgOnPage');

        return $payment->getConfigData($key);
    }
}
